/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefData;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSVersion;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipchGenericRefHost
extends OipchGenericRefData {
    public boolean hasStepNodes(Node oNode) {
        Node oStepNode = null;
        oStepNode = this.getNode("STEP", oNode);
        return oStepNode != null;
    }

    public boolean hasStepsNodes(Node oNode) {
        Node oStepNode = null;
        oStepNode = this.getNode("STEPS", oNode);
        return oStepNode != null;
    }

    public boolean isRangeProperty(Node oNode) {
        NamedNodeMap oAttribs = null;
        Node oAttrib1 = null;
        Node oAttrib2 = null;
        boolean bIsRange = false;
        if (oNode != null && (oAttribs = oNode.getAttributes()) != null) {
            oAttrib1 = oAttribs.getNamedItem("ATLEAST");
            oAttrib2 = oAttribs.getNamedItem("ATMOST");
            if (oAttrib1 != null || oAttrib2 != null) {
                bIsRange = true;
            }
        }
        return bIsRange;
    }

    public Node getSwapSizeNode() {
        String sSwapSizeNode = "SYSTEM/MEMORY/SWAP_SIZE";
        return this.getNode(sSwapSizeNode);
    }

    public Node getKernelStepsNode() {
        String sSwapSizeNode = "CERTIFIED_SYSTEMS/OPERATING_SYSTEM/KERNEL/PROPERTY";
        return this.getNode(sSwapSizeNode);
    }

    private boolean checkVersion(Node oOSNode, OipchVersion oVer) throws OixdInvalidDocumentException {
        OipchVersion oRefVer = this.getRefVersion(oOSNode);
        return oVer != null && oVer.equals(oRefVer);
    }

    public int getCurrentPlatform() throws OixdInvalidDocumentException {
        Element oHostNode = this.getDocument().getDocumentElement();
        NamedNodeMap oNodeAttribs = oHostNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            oAttrib = oNodeAttribs.getNamedItem("PLATID");
            if (oAttrib != null) {
                String sPlatID = oAttrib.getNodeValue();
                return Integer.parseInt(sPlatID);
            }
            return OiixPlatform.getCurrentPlatform();
        }
        return 0;
    }

    private OipchVersion getRefVersion(Node oOSNode) throws OixdInvalidDocumentException {
        OipchVersion oRefVer = null;
        int iPlatID = this.getCurrentPlatform();
        String sVersion = null;
        String sVendor = "";
        Node oVersionNode = this.getNode("VERSION", oOSNode);
        if (oVersionNode != null) {
            NamedNodeMap oNodeAttribs = oVersionNode.getAttributes();
            Node oAttrib = null;
            if (oNodeAttribs != null && (oAttrib = oNodeAttribs.getNamedItem("VALUE")) != null) {
                sVersion = oAttrib.getNodeValue();
            }
        }
        switch (iPlatID) {
            case 46: 
            case 110: 
            case 211: {
                Node oVendorNode = this.getNode("VENDOR", oOSNode);
                if (oVendorNode != null) {
                    NamedNodeMap oNodeAttribs = oVendorNode.getAttributes();
                    Node oAttrib = null;
                    if (oNodeAttribs != null && (oAttrib = oNodeAttribs.getNamedItem("VALUE")) != null) {
                        sVendor = oAttrib.getNodeValue();
                    }
                }
                oRefVer = new OipchLinuxOSVersion(sVendor + "-" + sVersion);
                break;
            }
            default: {
                oRefVer = new OipchVersion(sVersion);
            }
        }
        return oRefVer;
    }

    public Node getOSNode(OipchVersion oVer) throws OixdInvalidDocumentException {
        NodeList oOSNodes;
        Node oOSNode = null;
        Node oCertifiedSystemsNode = this.getNode("CERTIFIED_SYSTEMS");
        if (oCertifiedSystemsNode != null && (oOSNodes = oCertifiedSystemsNode.getChildNodes()) != null) {
            int nOSNodes = oOSNodes.getLength();
            for (int i = 0; i < nOSNodes; ++i) {
                oOSNode = oOSNodes.item(i);
                if (oOSNode.getNodeType() == 1 && oOSNode.getNodeName().equalsIgnoreCase("OPERATING_SYSTEM") && this.checkVersion(oOSNode, oVer)) {
                    return oOSNode;
                }
                oOSNode = null;
            }
        }
        return oOSNode;
    }

    public boolean hasExcludeNode(Node oNode) {
        Node oExcludeNode = null;
        oExcludeNode = this.getNode("EXCLUDE", oNode);
        return oExcludeNode != null;
    }

    public Node getSwapSizeNodes() {
        String sSwapSizeNode = "SYSTEM/MEMORY/SWAP_SIZE/STEPS";
        return this.getNode(sSwapSizeNode);
    }
}

